function [M_0,M_90,cuts_1horiz, cuts_1vert, cuts_2horiz, cuts_2vert, kkk]=derawsingle(M0_raw,M90_raw, NA, nenv)
opengl software

ratio=1;
 th = linspace(0,2*pi,200)';

 M0_raw = M0_raw(:,1:end)';
 M90_raw =  M90_raw(:,1:end)';

% figure(99)
% kk=pcolor(M0_raw); axis equal;
% set(kk, 'LineStyle', 'none');
% pointsM0 = (ginput(3));
% hold on

[XY0] = findcenter3(M0_raw);
[XY90] = findcenter3(M90_raw);

% [xc0,yc0,Re0,~] = circfit(pointsM0(:,1),pointsM0(:,2));
[xc0,yc0,Re0,~] = circfit(XY0(:,1)-3,XY0(:,2)+2);
[xc90,yc90,Re90,~] = circfit(XY90(:,1)-3,XY90(:,2)+2);

%       xe = Re0*cos(th)+xc0; ye = Re0*sin(th)+yc0;
%      kk=plot([xe;xe(1)],[ye;ye(1)]); set(kk, 'LineWidth', 3, 'Color', 'white');
% close figure 99

% figure(99)
% kk=pcolor(M90_raw); axis equal;
% set(kk, 'LineStyle', 'none');
% pointsM90 = round(ginput(3))
% [xc90,yc90,Re90,a90] = circfit(pointsM90(:,1),pointsM90(:,2));
% close figure 99

c0 = round([xc90+2 yc90+1]);
r0 = (Re90-2);
% c90 = round([xc90 yc90]);
% r90 = round(Re90);
% c90 = round([xc90 yc90]);
% r90 = (Re90);
c90 = c0;
r90 = r0;

M0=M0_raw;
M90=M90_raw*ratio;

% [c0,r0]=interp3p(pointsM0);
% [c90,r90]=interp3p(pointsM90);

% c0=[90 90];
% c90=c0;
% r0=[68];
% r90=r0;


%casting the matrices for preparation to correction
[M0_casted,ccast_0,size_0]=castimage(M0,c0,r0);  
[M90_casted,ccast_90,size_90]=castimage(M90,c90,r90);

%Passage from k-values to coresponding angle
[matx0,maty0]=anglecorrection(size_0,ccast_0,r0, NA, nenv);
[matx90,maty90]=anglecorrection(size_90,ccast_90,r90, NA, nenv);

%concatenation of the matrices
M_0=cat(3,M0_casted,matx0,maty0);
M_90=cat(3,M90_casted,matx90,maty90);

%correction of the intensity by a cosine function
M_0(:,:,1)=M_0(:,:,1).*cos(sqrt(M_0(:,:,2).^2+M_0(:,:,3).^2));
M_90(:,:,1)=M_90(:,:,1).*cos(sqrt(M_90(:,:,2).^2+M_90(:,:,3).^2));

% changing position
M_0(:,:,2)=M_0(:,:,2)-4/180*pi;
M_90(:,:,2)=M_90(:,:,2)-4/180*pi;

figure(1)
subplot(2,1,1)
pcolor(M_0(:,:,2)*180/pi,M_0(:,:,3)*180/pi,M_0(:,:,1)), shading flat %graph s
axis equal
colorbar;
colormap jet
title({'Polarization parallel to the axis'});
hold on
plot(-75:75, zeros(size(-75:75)),'--', 'LineWidth', 1, 'Color', 'white')
plot([-0.001 0.001], [-75 75], '--', 'LineWidth', 1, 'Color', 'white')
kk= polar(th, (asin(NA/nenv)*180/pi)*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 1.5, 'Color', 'white')
set(gca, 'FontSize', 20)
axis([-75 75 -75 75])

kk= polar(th, 20*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')
kk= polar(th, 40*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')
kk= polar(th, 60*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')

subplot(2,1,2)
pcolor(M_90(:,:,2)*180/pi,M_90(:,:,3)*180/pi,M_90(:,:,1)), shading flat %graph s
axis equal
colorbar;
colormap jet
title({'Polarization parallel to the axis'});
hold on
plot(-75:75, zeros(size(-75:75)),'--', 'LineWidth', 1, 'Color', 'white')
plot([-0.001 0.001], [-75 75], '--', 'LineWidth', 1, 'Color', 'white')
kk= polar(th, (asin(NA/nenv)*180/pi)*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 1.5, 'Color', 'white')
set(gca, 'FontSize', 20)
axis([-80 80 -80 80])

kk= polar(th, 20*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')
kk= polar(th, 40*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')
kk= polar(th, 60*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')

figure(2)

subplot(2,1,1)
pcolor(M0_raw); shading flat, axis equal; colorbar
hold on
plot(XY0(:,1), XY0(:,2), 'LineStyle', '--', 'Marker', '.', 'Color', 'white')
% axis([0 658 0 496])% figure

subplot(2,1,2)
pcolor(M90_raw); shading flat, axis equal; colorbar
hold on
plot(XY90(:,1), XY90(:,2), 'LineStyle', '--', 'Marker', '.', 'Color', 'white')
% axis([0 658 0 496])


figure(3)
subplot(2,2,[1 2])
pcolor(M_90(:,:,2)*180/pi,M_90(:,:,3)*180/pi,(M_90(:,:,1)+M_0(:,:,1))); shading flat %graph s
axis equal
colormap hot
colorbar
% whitebg('black');
hold on
plot(-75:75, zeros(size(-75:75)), '--', 'LineWidth', 1, 'Color', 'white')
plot([-0.001 0.001], [-75 75], '--', 'LineWidth', 1, 'Color', 'white')
axis([-80 80 -80 80])
kk= polar(th, (asin(NA/nenv)*180/pi)*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 1.5, 'Color', 'white')
set(gca, 'FontSize', 20)
%plotting some stuff, optional
% figure()
xlabel('\theta_x [\circ]','FontSize',30);
title('Sum of the polarized images', 'FontSize', 20)
% Create ylabel
ylabel('\theta_y [\circ]','FontSize',30);

kk= polar(th, 20*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')
kk= polar(th, 40*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')
kk= polar(th, 60*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')

subplot(2,2,3)
pcolor(M_0(:,:,2)*180/pi,M_0(:,:,3)*180/pi,M_0(:,:,1)), shading flat %graph s

axis equal
colorbar;
colormap hot
title({'Polarizer \Uparrow'}, 'FontSize', 20);
% whitebg('black');
hold on
plot(-75:75, zeros(size(-75:75)),'--', 'LineWidth', 1, 'Color', 'white')
plot([-0.001 0.001], [-75 75], '--', 'LineWidth', 1, 'Color', 'white')
axis([-80 80 -80 80])
xlabel('\theta_x [\circ]','FontSize',30);
kk= polar(th, (asin(NA/nenv)*180/pi)*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 1.5, 'Color', 'white')
set(gca, 'FontSize', 20)

% Create ylabel
ylabel('\theta_y [\circ]','FontSize',30);

kk= polar(th, 20*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')
kk= polar(th, 40*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')
kk= polar(th, 60*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')


subplot(2,2,4)
pcolor(M_90(:,:,2)*180/pi,M_90(:,:,3)*180/pi,M_90(:,:,1)), shading flat %graph s

axis equal
colorbar;
colormap hot
title({'Polarizer \Leftrightarrow'}, 'FontSize', 20);
% whitebg('black');
hold on
plot(-75:75, zeros(size(-75:75)),'--', 'LineWidth', 1, 'Color', 'white')
plot([-0.001 0.001], [-75 75], '--', 'LineWidth', 1, 'Color', 'white')
axis([-80 80 -80 80])
xlabel('\theta_x [\circ]','FontSize',30);
kk= polar(th, (asin(NA/nenv)*180/pi)*ones(size(th)));
set(gca, 'FontSize', 20)

set(kk, 'LineStyle', '--', 'LineWidth', 1.5, 'Color', 'white')
% Create ylabel
ylabel('\theta_y [\circ]','FontSize',30);

kk= polar(th, 20*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')
kk= polar(th, 40*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')
kk= polar(th, 60*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')

% figure(4)
% pcolor(M_90(:,:,2)*180/pi,M_90(:,:,3)*180/pi,(M_90(:,:,1)+M_0(:,:,1))); shading flat %graph s
% axis equal
% colormap jet
% colorbar
% % whitebg('black');
% hold on
% plot(-75:75, zeros(size(-75:75)), '--', 'LineWidth', 1, 'Color', 'white')
% plot([-0.001 0.001], [-75 75], '--', 'LineWidth', 1, 'Color', 'white')
% axis([-60 60 -60 60])
% kk= polar(th, (asin(NA/nenv)*180/pi)*ones(size(th)));
% set(kk, 'LineStyle', '--', 'LineWidth', 1.5, 'Color', 'white')
% set(gca, 'FontSize', 20)
% %plotting some stuff, optional
% % figure()
% xlabel('\theta_x [\circ]','FontSize',30);
% title('Far field emission pattern', 'FontSize', 20)
% % Create ylabel
% ylabel('\theta_y [\circ]','FontSize',30);
% 
% kk= polar(th, 20*ones(size(th)));
% set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')
% kk= polar(th, 40*ones(size(th)));
% set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')
% kk= polar(th, 60*ones(size(th)));
% set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')

figure(8)
pcolor(M_90(:,:,2)*180/pi,M_90(:,:,3)*180/pi,(M_90(:,:,1)+M_0(:,:,1))); shading flat %graph s
axis equal
colormap hot
colorbar
% whitebg('black');
hold on
plot(-75:75, zeros(size(-75:75)), '--', 'LineWidth', 1, 'Color', 'white')
plot([-0.001 0.001], [-75 75], '--', 'LineWidth', 1, 'Color', 'white')
axis([-80 80 -80 80])
kk= polar(th, (asin(NA/nenv)*180/pi)*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 1.5, 'Color', 'white')
set(gca, 'FontSize', 20)
%plotting some stuff, optional
% figure()
xlabel('\theta_x [\circ]','FontSize',30);
title('Emission pattern', 'FontSize', 20)
% Create ylabel
ylabel('\theta_y [\circ]','FontSize',30);

kk= polar(th, 20*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')
kk= polar(th, 40*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')
kk= polar(th, 60*ones(size(th)));
set(kk, 'LineStyle', '--', 'LineWidth', 0.5, 'Color', 'white')


figure(7)
subplot(1,3,1)
plot(M_0((round(size(M_0,1)/2)), :, 2)*180/pi, M_0((round(size(M_0,1)/2)), :, 1), 'red', 'LineWidth', 3) 
hold on
plot(M_90(:, (round(size(M_90,2)/2)), 3)*180/pi, M_90( :,(round(size(M_90,2)/2)), 1), 'green', 'LineWidth', 3) 
xlim([-75 75])
subplot(1,3,2)
plot(M_90((round(size(M_90,1)/2)), :, 2)*180/pi, M_90((round(size(M_90,1)/2)), :, 1), 'green', 'LineWidth', 3) 
hold on
plot(M_0(:, (round(size(M_0,2)/2)), 3)*180/pi, M_0( :,(round(size(M_0,2)/2)), 1), 'red', 'LineWidth', 3) 
xlim([-75 75])
subplot(1,3,3)
plot(M_90((round(size(M_90,1)/2)), :, 2)*180/pi, M_90((round(size(M_90,1)/2)),:,1) + M_0((round(size(M_0,1)/2)),:,1), 'green', 'LineWidth', 3) 
hold on
plot(M_0(:, (round(size(M_0,2)/2)), 3)*180/pi, M_0( :,(round(size(M_0,2)/2)),1) + M_90(:,(round(size(M_90,2)/2)),1), 'red', 'LineWidth', 3) 
plot(-60:1:60,cos([-60:1:60]/180*pi)*max(M_0( :,(round(size(M_0,2)/2)),1) + M_0((round(size(M_0,1)/2)),:,1)'))
xlim([-75 75])

cuts_1horiz = [(M_0((round(size(M_0,1)/2)), :, 2)*180/pi)', (M_0((round(size(M_0,1)/2)), :, 1))'];
cuts_1vert = [M_0(:, (round(size(M_0,2)/2)), 3)*180/pi, M_0( :,(round(size(M_0,2)/2)), 1)];
cuts_2horiz = [(M_90((round(size(M_90,1)/2)), :, 2)*180/pi)', (M_90((round(size(M_90,1)/2)), :, 1))'];
cuts_2vert = [M_90(:, (round(size(M_90,2)/2)), 3)*180/pi, M_90( :,(round(size(M_90,2)/2)), 1)];

[kk1(:,1), kk1(:,2)]= pol2cart(th, 20*ones(size(th)));
[kk2(:,1), kk2(:,2)]= pol2cart(th, 40*ones(size(th)));
[kk3(:,1), kk3(:,2)]= pol2cart(th, 60*ones(size(th)));
[kk4(:,1), kk4(:,2)]= pol2cart(th, asin(NA/nenv)*ones(size(th))*180/pi);

kkk = [kk1 kk2 kk3 kk4]*pi/180;

end